package ru.yandex.travel.hotels.promogranter.services.plus_topup

import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.boot.context.properties.ConstructorBinding
import ru.yandex.travel.cpa.tours.EEnvironment
import java.time.Duration

@ConstructorBinding
@ConfigurationProperties(value = "plus-topup-initializer", ignoreUnknownFields = false)
data class PlusTopupInitializerServiceProperties(
    val enabled: Boolean = false,
    val initializationOfTopupsEnabled: Boolean = true,
    val schedulingOfTopupsEnabled: Boolean = true,
    val syncTopupStatusesEnabled: Boolean = true,
    val exportToYtEnabled: Boolean = true,
    val period: Duration = Duration.ofSeconds(10),
    val topupCategory: String = "level-travel-tours",
    val toursPlusPercent: Long = 5,
    val toursPlusMaxAmount: Long = 5000,
    val toursCommissionVatPercent: Long = 20,
    val toursLabelTtlDays: Long = 730,
    val toursTopupInfoYtPath: String,
    val toursTopupInfoYtExportPeriod: Duration = Duration.ofMinutes(5),
    val additionalBindingTtlDays: Long = 365,
    val dangerouslyTopupImmediatelyUseOnlyInTesting: Boolean = false,
    val expectedLabelEnv: EEnvironment,
)
