package ru.yandex.travel.hotels.promogranter.services.yt_publish

import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.boot.context.properties.ConstructorBinding
import java.time.Duration

@ConstructorBinding
@ConfigurationProperties(value = "yt-publisher", ignoreUnknownFields = false)
data class YtPublisherProperties(
    val enabled: Boolean,
    val clusters: List<String>,
    val token: String,
    val transactionDuration: Duration = Duration.ofSeconds(120)
)
