CREATE TABLE plus_topups
(
    plus_topup_id           UUID NOT NULL,
    topup_category          VARCHAR(255) NOT NULL,
    travel_order_id         VARCHAR(255) NOT NULL,
    created_at              TIMESTAMP    NOT NULL,
    updated_at              TIMESTAMP    NOT NULL,

    topup_amount            NUMERIC NOT NULL,
    order_amount            NUMERIC NOT NULL,
    commission_amount       NUMERIC NOT NULL,
    vat_commission_amount   NUMERIC NOT NULL,
    user_ip                 VARCHAR(255) NOT NULL,

    passport_id             VARCHAR(255) NOT NULL,

    scheduled               BOOL NOT NULL,
    finished                BOOL NOT NULL,
    status                  INT,
    finished_at             TIMESTAMP,
    trust_purchase_token    VARCHAR(255),

    PRIMARY KEY (plus_topup_id)
);

CREATE UNIQUE INDEX plus_topups_travel_order_id_unique_idx ON plus_topups (topup_category, travel_order_id);
CREATE INDEX plus_topups_scheduled_idx ON plus_topups (scheduled);

CREATE TABLE additional_bindings
(
    binding_id              UUID NOT NULL,
    topup_category          VARCHAR(255) NOT NULL,
    travel_order_id         VARCHAR(255) NOT NULL,
    created_at              TIMESTAMP    NOT NULL,
    updated_at              TIMESTAMP    NOT NULL,

    user_ip                 VARCHAR(255) NOT NULL,
    passport_id             VARCHAR(255) NOT NULL,

    PRIMARY KEY (binding_id)
);

CREATE UNIQUE INDEX additional_bindings_travel_order_id_unique_idx ON additional_bindings (topup_category, travel_order_id);
