RECURSE(
    src/test
)

JAVA_PROGRAM(promogranter)

JDK_VERSION(11)
WITH_KOTLIN()
INCLUDE(${ARCADIA_ROOT}/travel/library/java/dependencies.inc)

OWNER(g:travel-hotels)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/generated **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)

PEERDIR(
    travel/hotels/promogranter/proto
    travel/hotels/proto/promogranter_service
    travel/orders/proto/services/orders/yandex_plus
    travel/orders/proto/services/orders
    travel/proto/cpa/tours

    travel/library/java/spring-boot-skeleton
    travel/library/java/natives
    travel/library/java/yt-utils
    travel/library/java/yt-lucene-index
    travel/library/java/tvm-commons
    travel/library/java/ha-grpc-client
    travel/library/java/ha-grpc-client-spring-configuration

    contrib/java/com/h2database/h2
    contrib/java/org/postgresql/postgresql
    contrib/java/org/springframework/boot/spring-boot-starter-jdbc
    contrib/java/org/jooq/jooq
    contrib/java/org/flywaydb/flyway-core

    contrib/java/org/jetbrains/kotlin/kotlin-reflect
    contrib/java/javax/persistence/javax.persistence-api/2.2
    contrib/java/org/springframework/boot/spring-boot-starter-validation
)

GENERATE_SCRIPT(
    TEMPLATE ${ARCADIA_ROOT}/travel/hotels/devops/starter/starter.template.py
    OUT ${BINDIR}/bin/promogranter.py
    CUSTOM_PROPERTY appName promogranter
    CUSTOM_PROPERTY mainClass ru.yandex.travel.hotels.promogranter.PromoGranterApplication
)

LINT(base)

END()
