#include "counters.h"
#include "service.h"

namespace NTravel {
namespace NRedir {

TServiceCounters::TServiceCounters(TService& service)
    : Service_(service)
{
}

void TServiceCounters::QueryCounters(NMonitor::TCounterTable* ct) const {
    IsReady = Service_.IsReady() ? 1: 0;
    PingIsMissing = Service_.IsPinged() ? 0 : 1;

    ct->insert(MAKE_COUNTER_PAIR(IsReady));
    ct->insert(MAKE_COUNTER_PAIR(PingIsMissing));
}

namespace NHotels {

static std::initializer_list<int> g_CacheAgeHoursBuckets = {0, 1, 2, 3, 4, 6, 12, 24, 25};

TPerRequestCounters::TPerRequestCounters()
    : CacheAgeHours(g_CacheAgeHoursBuckets)
{
}

void TPerRequestCounters::QueryCounters(NMonitor::TCounterTable* ct) const {
    ct->insert(MAKE_COUNTER_PAIR(NRequests));
    ct->insert(MAKE_COUNTER_PAIR(NRequestsMMAds));
    ct->insert(MAKE_COUNTER_PAIR(NRequestsByOldOffer));
    ct->insert(MAKE_COUNTER_PAIR(NRequestsByUrl));
    ct->insert(MAKE_COUNTER_PAIR(NRequestsByToken));
    ct->insert(MAKE_COUNTER_PAIR(NRequestsByOfferId));

    ct->insert(MAKE_COUNTER_PAIR(NResponsesOK));
    ct->insert(MAKE_COUNTER_PAIR(NResponsesNoRedir));

    for (size_t i = 0; i < Y_ARRAY_SIZE(NDestination); ++i) {
        ct->insert(MAKE_NAMED_COUNTER_PAIR("NDestination_" + NTravelProto::ERedirDestination_Name(NTravelProto::ERedirDestination(i)), NDestination[i]));
    }

    for (size_t i = 0; i < Y_ARRAY_SIZE(NSurface); ++i) {
        ct->insert(MAKE_NAMED_COUNTER_PAIR("NSurface_" + NTravelProto::ESurface_Name(NTravelProto::ESurface(i)), NSurface[i]));
    }

    // Ошибки
    ct->insert(MAKE_COUNTER_PAIR(NRequestsUnknown));
    ct->insert(MAKE_COUNTER_PAIR(NUrlDecodeErrors));
    ct->insert(MAKE_COUNTER_PAIR(NLabelDecodeErrors));
    ct->insert(MAKE_COUNTER_PAIR(NTokenDecodeErrors));
    ct->insert(MAKE_COUNTER_PAIR(NAddInfoDecodeErrors));
    ct->insert(MAKE_COUNTER_PAIR(NRequestErrors));
    ct->insert(MAKE_COUNTER_PAIR(NRequestsNoLabel));
    ct->insert(MAKE_COUNTER_PAIR(NOfferDataWithoutRedirInfo));
    ct->insert(MAKE_COUNTER_PAIR(NReqByOfferIdTooOld));
    ct->insert(MAKE_COUNTER_PAIR(NOfferDataNotFound));
    ct->insert(MAKE_COUNTER_PAIR(NFailedToReadOfferData));
    ct->insert(MAKE_COUNTER_PAIR(NOfferDataUrlDecodeErrors));
    ct->insert(MAKE_COUNTER_PAIR(NOfferDataTokenDecodeErrors));
    ct->insert(MAKE_COUNTER_PAIR(NReqByOfferIdWithWrongHash));
    ct->insert(MAKE_COUNTER_PAIR(NSuccessfulReqByOfferIdWithWrongHash));

    CacheAgeHours.QueryCounters("CacheAgeLess", "Hours", ct);
}


} // namespace NHotels

namespace NTrains {

void TPerRequestCounters::QueryCounters(NMonitor::TCounterTable* ct) const {
    ct->insert(MAKE_COUNTER_PAIR(NRequests));
    ct->insert(MAKE_COUNTER_PAIR(NRequestErrors));
    ct->insert(MAKE_COUNTER_PAIR(NLabelDecodeErrors));
    ct->insert(MAKE_COUNTER_PAIR(NRequestsNoLabel));
}

} // namespace NTrains

namespace NBuses {

void TPerRequestCounters::QueryCounters(NMonitor::TCounterTable* ct) const {
    ct->insert(MAKE_COUNTER_PAIR(NRequests));
    ct->insert(MAKE_COUNTER_PAIR(NRequestErrors));
    ct->insert(MAKE_COUNTER_PAIR(NLabelDecodeErrors));
    ct->insert(MAKE_COUNTER_PAIR(NRequestsNoLabel));
}

} // namespace NBuses

namespace NSuburban {

void TPerRequestCounters::QueryCounters(NMonitor::TCounterTable* ct) const {
    ct->insert(MAKE_COUNTER_PAIR(NRequests));
    ct->insert(MAKE_COUNTER_PAIR(NRequestErrors));
    ct->insert(MAKE_COUNTER_PAIR(NLabelDecodeErrors));
    ct->insert(MAKE_COUNTER_PAIR(NRequestsNoLabel));
}

} // namespace NSuburban


namespace NTours {

    void TPerRequestCounters::QueryCounters(NMonitor::TCounterTable* ct) const {
        ct->insert(MAKE_COUNTER_PAIR(NRequests));
        ct->insert(MAKE_COUNTER_PAIR(NRequestErrors));
        ct->insert(MAKE_COUNTER_PAIR(NLabelDecodeErrors));
        ct->insert(MAKE_COUNTER_PAIR(NRequestsNoLabel));
    }

} // namespace NTours

} // namespace NRedir
} // namespace NTravel
