#pragma once

#include <travel/hotels/proto2/hotels.pb.h>

#include <travel/hotels/lib/cpp/mon/counter.h>
#include <travel/hotels/lib/cpp/mon/counter_hypercube.h>
#include <travel/hotels/lib/cpp/mon/tools.h>

namespace NTravel {
namespace NRedir {

class TService;

struct TServiceCounters : public NMonitor::TCounterSource {
    mutable NMonitor::TCounter IsReady;
    mutable NMonitor::TCounter PingIsMissing; // Давно нет пинга от балансера (негативная логика лучше для алертов соломона)

    TService& Service_;

    TServiceCounters(TService& service);
    void QueryCounters(NMonitor::TCounterTable* ct) const override;
};

namespace NHotels {

// Cube dimensions:
// 1. Operator
//
struct TPerRequestCounters : public NMonitor::TCounterSource {
    NMonitor::TDerivCounter NRequests;
    NMonitor::TDerivCounter NRequestsMMAds;
    NMonitor::TDerivCounter NRequestsByOldOffer;
    NMonitor::TDerivCounter NRequestsByUrl;
    NMonitor::TDerivCounter NRequestsByToken;
    NMonitor::TDerivCounter NRequestsByOfferId;

    NMonitor::TDerivCounter NResponsesOK;
    NMonitor::TDerivCounter NResponsesNoRedir;

    NMonitor::TDerivCounter NSurface[NTravelProto::ESurface_MAX + 1];
    NMonitor::TDerivCounter NDestination[NTravelProto::ERedirDestination_MAX + 1];

    // Ошибки
    NMonitor::TDerivCounter NRequestsUnknown;
    NMonitor::TDerivCounter NUrlDecodeErrors;
    NMonitor::TDerivCounter NLabelDecodeErrors;
    NMonitor::TDerivCounter NTokenDecodeErrors;
    NMonitor::TDerivCounter NAddInfoDecodeErrors;
    NMonitor::TDerivCounter NRequestErrors;
    NMonitor::TDerivCounter NRequestsNoLabel;
    NMonitor::TDerivCounter NOfferDataWithoutRedirInfo;
    NMonitor::TDerivCounter NReqByOfferIdTooOld;
    NMonitor::TDerivCounter NOfferDataNotFound;
    NMonitor::TDerivCounter NFailedToReadOfferData;
    NMonitor::TDerivCounter NOfferDataUrlDecodeErrors;
    NMonitor::TDerivCounter NOfferDataTokenDecodeErrors;
    NMonitor::TDerivCounter NReqByOfferIdWithWrongHash;
    NMonitor::TDerivCounter NSuccessfulReqByOfferIdWithWrongHash;

    NMonitor::TDerivHistogramCounter CacheAgeHours;

    TPerRequestCounters();
    void QueryCounters(NMonitor::TCounterTable* ct) const override;
};
using TPerRequestCountersRef = TAtomicSharedPtr<TPerRequestCounters>;

} // namespace NHotels

namespace NTrains {

//
struct TPerRequestCounters : public NMonitor::TCounterSource {
    NMonitor::TDerivCounter NRequests;
    NMonitor::TDerivCounter NRequestErrors;
    NMonitor::TDerivCounter NLabelDecodeErrors;
    NMonitor::TDerivCounter NRequestsNoLabel;

    void QueryCounters(NMonitor::TCounterTable* ct) const override;
};
using TPerRequestCountersRef = TAtomicSharedPtr<TPerRequestCounters>;

} // namespace NTrains

namespace NBuses {

//
struct TPerRequestCounters : public NMonitor::TCounterSource {
    NMonitor::TDerivCounter NRequests;
    NMonitor::TDerivCounter NRequestErrors;
    NMonitor::TDerivCounter NLabelDecodeErrors;
    NMonitor::TDerivCounter NRequestsNoLabel;

    void QueryCounters(NMonitor::TCounterTable* ct) const override;
};
using TPerRequestCountersRef = TAtomicSharedPtr<TPerRequestCounters>;

} // namespace NBuses

namespace NSuburban {

//
struct TPerRequestCounters : public NMonitor::TCounterSource {
    NMonitor::TDerivCounter NRequests;
    NMonitor::TDerivCounter NRequestErrors;
    NMonitor::TDerivCounter NLabelDecodeErrors;
    NMonitor::TDerivCounter NRequestsNoLabel;

    void QueryCounters(NMonitor::TCounterTable* ct) const override;
};
using TPerRequestCountersRef = TAtomicSharedPtr<TPerRequestCounters>;

} // namespace NSuburban

namespace NTours {
    struct TPerRequestCounters : public NMonitor::TCounterSource {
        NMonitor::TDerivCounter NRequests;
        NMonitor::TDerivCounter NRequestErrors;
        NMonitor::TDerivCounter NLabelDecodeErrors;
        NMonitor::TDerivCounter NRequestsNoLabel;

        void QueryCounters(NMonitor::TCounterTable* ct) const override;
    };
    using TPerRequestCountersRef = TAtomicSharedPtr<TPerRequestCounters>;
} // namespace NTours


} // namespace NRedir
} // namespace NTravel
