#pragma once

#include "service.h"

#include <travel/hotels/redir/proto/api.pb.h>
#include <travel/hotels/proto/redir_add_info/redir_add_info.pb.h>
#include <travel/hotels/proto2/label.pb.h>
#include <travel/hotels/lib/cpp/http/http_service.h>
#include <travel/hotels/lib/cpp/util/exp.h>
#include <travel/hotels/lib/cpp/util/url.h>

#include <util/system/event.h>

namespace NTravel {
namespace NRedir {
namespace NHotels {

class TJob
{
public:
    TJob(TService& svc, TYtKeyValueStorage& searchFlowOfferDataStorage, NHttp::TOnResponse onResp, ui64 id);
    ~TJob();

    void Run(const NHttp::TRequest& httpReq);
private:

    TService& Service;
    const NHttp::TOnResponse ResponseCb;
    const TString LogPrefix;
    const TInstant Started;

    TYtKeyValueStorage& SearchFlowOfferDataStorage;

    // Общие данные
    TPerRequestCountersRef OpCounters;

    NTravelProto::NRedir::NApi::THotels_RedirReq Req;

    TUrl Url;
    TString UrlWithoutLabel;

    NTravelProto::TLabel Label;
    NTravelProto::TTravelToken Token;
    NTravelProto::NRedirAddInfo::TRedirAddInfo AddInfo;
    TExp Exp;

    TString LabelHash;
    bool LabelHashOverriden;

    void ProcessModeNormal();
    void ProcessModeMMAds();

    void Parse();

    void SetDefaultPortalSchemeAndHost();

    void ProcessOldRequest();
    void ProcessByPUrl();
    void DoRedirByPUrl();
    void ProcessByToken();
    void DoRedirByToken(const NTravelProto::TTravelToken& token, const TString& rawToken);
    void ProcessByOfferId();
    void DoFallbackRedirByLabel();

    void TryParsePreviousLabelFromLabelHash();

    void CalcLabelHash();
    void PutLabelToUrl(bool asHash);
    void Reply() const;

    void WriteReqAns() const;
    void WritePriceCheckerRequest() const;
};

} // namespace NHotels
} // namespace NRedir
} // namespace NTravel
