#pragma once

#include "counters.h"

#include <travel/hotels/redir/proto/config.pb.h>
#include <travel/hotels/redir/proto/reqans_hotels.pb.h>
#include <travel/hotels/redir/proto/reqans_trains.pb.h>
#include <travel/hotels/redir/proto/reqans_buses.pb.h>
#include <travel/hotels/redir/proto/reqans_suburban.pb.h>
#include <travel/hotels/redir/proto/reqans_tours.pb.h>

#include <travel/hotels/proto/data_config/partner.pb.h>
#include <travel/hotels/proto2/hotels.pb.h>
#include <travel/hotels/proto2/bus_messages.pb.h>

#include <travel/hotels/lib/cpp/data/data.h>
#include <travel/hotels/lib/cpp/encryption/codec.h>
#include <travel/hotels/lib/cpp/http/http_service.h>
#include <travel/hotels/lib/cpp/label/label.h>
#include <travel/hotels/lib/cpp/logging/common_logger.h>
#include <travel/hotels/lib/cpp/util/flag.h>
#include <travel/hotels/lib/cpp/util/restart_detector.h>
#include <travel/hotels/lib/cpp/yt/persistent_config.h>
#include <travel/hotels/lib/cpp/yt/queue_writer.h>

#include <travel/hotels/lib/cpp/mon/page.h>

#include <library/cpp/http/client/query.h>
#include <library/cpp/http/client/request.h>

#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/system/event.h>
#include <travel/hotels/lib/cpp/yt/key_value_storage.h>

namespace NTravel {
namespace NRedir {

class TService
{
public:
    TService(const NTravelProto::NRedir::TConfig& pbCfg);
    ~TService();
    void Run();
    void Stop();

    const NTravelProto::NRedir::TConfig& Config() const;
    TServiceCounters& ServiceCounters();
    NHotels::TPerRequestCountersRef HotelsPerRequestCounters(EOperatorId opId);
    NTrains::TPerRequestCountersRef TrainsPerRequestCounters();
    NBuses::TPerRequestCountersRef BusesPerRequestCounters();
    NSuburban::TPerRequestCountersRef SuburbanPerRequestCounters();
    NTours::TPerRequestCountersRef ToursPerRequestCounters();
    NEncryption::TUrlCodec&   UrlCodec();
    NEncryption::TTokenCodec& TokenCodec();
    NEncryption::TTokenCodec& AddInfoCodec();
    NLabel::TLabelCodec& LabelCodec();

    std::shared_ptr<const NTravelProto::NConfig::TPartner> GetPartnerConfig(EPartnerId pId);
    const NTravelProto::NRedir::TConfig::TBoYRules::TRule& GetBoYRule(NTravelProto::ESurface surface) const;

    void WritePriceCheckerRequest(const ru::yandex::travel::hotels::TPriceCheckReq& req);
    void WriteReqAnsHotels(const NTravelProto::NRedir::NHotels::TReqAnsLogRecord& record);
    void WriteReqAnsTrains(const NTravelProto::NRedir::NTrains::TReqAnsLogRecord& record);
    void WriteReqAnsBuses(const NTravelProto::NRedir::NBuses::TReqAnsLogRecord& record);
    void WriteReqAnsSuburban(const NTravelProto::NRedir::NSuburban::TReqAnsLogRecord& record);
    void WriteReqAnsTours(const NTravelProto::NRedir::NTours::TReqAnsLogRecord& record);

    bool IsReady() const;
    bool IsPinged() const;
    bool IsPingEnabled() const;
private:
    void OnPing(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnPingNanny(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnPingDisable(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnSetLogLevel(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnReopenReqAnsHotelsLog(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnReopenReqAnsTrainsLog(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnReopenReqAnsBusesLog(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnReopenReqAnsSuburbanLog(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnReopenReqAnsToursLog(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnReopenMainLog(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnWaitFlush(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnShutdown(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnHotelsRedir(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnTrainsLabelToHash(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnBusesLabelToHash(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnSuburbanLabelToHash(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnToursLabelToHash(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnFail(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
private:

    const NTravelProto::NRedir::TConfig Config_;
    THashMap<NTravelProto::ESurface, NTravelProto::NRedir::TConfig::TBoYRules::TRule> BoYRules_;

    TYtPersistentConfig<EPartnerId, NTravelProto::NConfig::TPartner> YtConfigPartners_;

    NMonitor::TBasicPage   CountersPage_;
    NMonitor::THttpService MonWebService_;
    mutable TServiceCounters      ServiceCounters_;
    NMonitor::TCounterHypercube<NHotels::TPerRequestCounters> HotelsPerRequestCounters_;
    NMonitor::TCounterHypercube<NTrains::TPerRequestCounters> TrainsPerRequestCounters_;
    NMonitor::TCounterHypercube<NBuses::TPerRequestCounters> BusesPerRequestCounters_;
    NMonitor::TCounterHypercube<NSuburban::TPerRequestCounters> SuburbanPerRequestCounters_;
    NMonitor::TCounterHypercube<NTours::TPerRequestCounters> ToursPerRequestCounters_;

    NEncryption::TUrlCodec   UrlCodec_;
    NEncryption::TTokenCodec TokenCodec_;
    NEncryption::TTokenCodec AddInfoCodec_;
    NLabel::TLabelCodec LabelCodec_;
    NHttp::TServer        Http_;
    TCommonLogger<NTravelProto::NRedir::NHotels::TReqAnsLogRecord> ReqAnsHotelsLogger_;
    TCommonLogger<NTravelProto::NRedir::NTrains::TReqAnsLogRecord> ReqAnsTrainsLogger_;
    TCommonLogger<NTravelProto::NRedir::NBuses::TReqAnsLogRecord> ReqAnsBusesLogger_;
    TCommonLogger<NTravelProto::NRedir::NSuburban::TReqAnsLogRecord> ReqAnsSuburbanLogger_;
    TCommonLogger<NTravelProto::NRedir::NTours::TReqAnsLogRecord> ReqAnsToursLogger_;

    TYtQueueWriter        PriceCheckReqBus_;

    TYtKeyValueStorage    SearchFlowOfferDataStorage_;

    TAutoEvent            StopEvent_;
    TAtomicFlag           PingEnabled_;
    TAtomicFlag           IsShuttingDown_;

    TMutex                LastPingLock_;
    TInstant              LastPing_;
    TAtomicFlag           SeenBalancerPing_;

    TRestartDetector      RestartDetector_;

    TAtomic               LastJobId_;
    TAtomic               ActiveJobCount_;

};

} // namespace NRedir
} // namespace NTravel
