#include "tools.h"

#include <travel/hotels/lib/cpp/util/base64.h>

#include <library/cpp/logger/global/global.h>
#include <google/protobuf/descriptor.h>
#include <util/string/cast.h>

namespace NTravel {
namespace NRedir {

TString BoolToString(bool v) {
    return v ? "true" : "false";
}

void PutFieldsMapToLog(const ::google::protobuf::Message& label, ::google::protobuf::Map<TString, TString>* fieldsMap) {
    const ::google::protobuf::Descriptor* descr = label.GetDescriptor();
    for (int fieldNo = 0; fieldNo < descr->field_count(); ++fieldNo) {
        const ::google::protobuf::FieldDescriptor* field = descr->field(fieldNo);
        Y_VERIFY(field->number() >= 1);
        TString strValue;
        auto r = label.GetReflection();
        switch (field->cpp_type()) {
#define PROCESS(PROTO_TYPE, MEMBER, TO_STRING)                                           \
            case ::google::protobuf::FieldDescriptor::PROTO_TYPE: {                      \
                if (field->is_repeated()) {                                              \
                    for (int idx = 0; idx < r->FieldSize(label, field); ++idx) {         \
                        if (strValue) { strValue += ","; }                               \
                        strValue += ToString(r->GetRepeated##MEMBER(label, field, idx)); \
                    }                                                                    \
                } else {                                                                 \
                    strValue = TO_STRING(r->Get##MEMBER(label, field));                  \
                }                                                                        \
                break;                                                                   \
            }
            PROCESS(CPPTYPE_BOOL, Bool, BoolToString);
            PROCESS(CPPTYPE_INT32, Int32, ToString);
            PROCESS(CPPTYPE_INT64, Int64, ToString);
            PROCESS(CPPTYPE_UINT32, UInt32, ToString);
            PROCESS(CPPTYPE_UINT64, UInt64, ToString);
            PROCESS(CPPTYPE_DOUBLE, Double, ToString);
            PROCESS(CPPTYPE_FLOAT, Float, ToString);
            PROCESS(CPPTYPE_STRING, String, ToString);
#undef PROCESS
            case ::google::protobuf::FieldDescriptor::CPPTYPE_ENUM: {
                Y_VERIFY(!field->is_repeated());// not supported
                strValue = ToString(r->GetEnum(label, field)->number());
                break;
            }
            default:
                ERROR_LOG << "Cannot process field " << field->name() << ", type is not known: " << (int)field->cpp_type() << Endl;
                break;
        }
        (*fieldsMap)[field->name()] = strValue;
    }
}

}// NRedir
}// NTravel
