#pragma once

#include "service.h"

#include <travel/proto/trains/label_params.pb.h>
#include <travel/hotels/redir/proto/api.pb.h>
#include <travel/hotels/lib/cpp/http/http_service.h>

#include <util/system/event.h>

namespace NTravel {
namespace NRedir {
namespace NTrains {

class TJob
{
public:
    TJob(TService& svc, NHttp::TOnResponse onResp, ui64 id);
    ~TJob();

    void Run(const NHttp::TRequest& httpReq);
private:
    TService& Service;
    const NHttp::TOnResponse ResponseCb;
    const TString LogPrefix;
    const TInstant Started;

    // Общие данные
    TPerRequestCountersRef Counters;

    NTravelProto::NRedir::NApi::TTrains_LabelToHashReq Req;
    NTravelProto::NTrains::TLabelParams LabelParams;
    TString LabelHash;

    void Parse();
    void Process();
    void Reply() const;

    void WriteReqAns() const;
};

} // namespace NTrains
} // namespace NRedir
} // namespace NTravel
