package ru.yandex.travel.hotels.searcher;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import ru.yandex.travel.hotels.common.encryption.EncryptionService;
import ru.yandex.travel.hotels.common.token.TokenCodec;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

@Configuration
@EnableConfigurationProperties(EncryptionConfigurationProperties.class)
public class EncryptionConfiguration {
    @Bean
    public EncryptionService getEncryptionService(EncryptionConfigurationProperties properties) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return new EncryptionService(properties.getEncryptionKey());
    }

    @Bean
    public TokenCodec getTokenCodec(EncryptionService encryptionService) {
        return new TokenCodec(encryptionService);
    }

}
