package ru.yandex.travel.hotels.searcher;

import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;

import ru.yandex.travel.hotels.common.partners.expedia.ApiVersion;

@Configuration
public class PropertyConvertersConfiguration {
    @ConfigurationPropertiesBinding
    @Bean
    public Converter<Object, ApiVersion> expediaVersionConfigurationBinding() {
        return new Converter<Object, ApiVersion>() {
            @Override
            public ApiVersion convert(Object source) {
                return ApiVersion.fromString(source.toString());
            }
        };
    }

}
