package ru.yandex.travel.hotels.searcher;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.PropertySource;

@SpringBootApplication
@EnableConfigurationProperties(SearcherApplicationProperties.class)
@PropertySource(value = "file:./secrets.properties", ignoreResourceNotFound = true)
public class SearcherApplication {
    public static void main(String[] args) {
        SpringApplication.run(SearcherApplication.class, args);
    }
}
