package ru.yandex.travel.hotels.searcher.cold;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;

@ConfigurationProperties(value = "cold", ignoreUnknownFields = false)
@Data
public class ColdConfigurationProperties {
    private boolean deducerEnabled = false;
    private Duration defaultLifetime = Duration.ofMinutes(20);
    private Duration emptyLifetime = Duration.ofHours(6);
    private Duration updateInterval = Duration.ofMinutes(30);
    private String proxy = "hahn.yt.yandex.net";
    // TODO(kirbo): avoid setting the token twice
    private String token;
    private String tablePath;
}
