package ru.yandex.travel.hotels.searcher.health;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

import ru.yandex.travel.commons.messaging.MessageBus;


@Component
public class BusHealthIndicator implements HealthIndicator {
    private MessageBus messageBus;

    public BusHealthIndicator(@Qualifier("messageBus") MessageBus messageBus) {
        this.messageBus = messageBus;
    }

    @Override
    public Health health() {
        return HealthConverter.convertHealthStatus(messageBus.isAlive());
    }
}