package ru.yandex.travel.hotels.searcher.health;

import java.util.Map;

import org.springframework.boot.actuate.health.Health;

import ru.yandex.travel.commons.messaging.ClusterHealthStatus;

public class HealthConverter {
    public static Health convertHealthStatus(ClusterHealthStatus status) {
        Health.Builder builder = new Health.Builder();
        if (status.isUp()) {
            builder.up();
        } else {
            builder.down();
        }
        for (Map.Entry<String, String> entry : status.getDetails().entrySet()) {
            builder.withDetail(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }
}
