package ru.yandex.travel.hotels.searcher.health;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

import ru.yandex.travel.commons.messaging.KeyValueStorage;

@Component
public class KvHealthIndicator implements HealthIndicator {
    @Autowired
    @Qualifier("keyValueStorage")
    KeyValueStorage keyValueStorage;

    @Override
    public Health health() {

        if (keyValueStorage.isHealthy()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }

    }
}
