package ru.yandex.travel.hotels.searcher.health;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

import ru.yandex.travel.commons.messaging.KeyValueStorage;

@Component
public class SearchFlowKvHealthIndicator implements HealthIndicator {
    @Autowired
    @Qualifier("searchFlowOfferDataStorage")
    KeyValueStorage searchFlowOfferDataStorage;

    @Override
    public Health health() {
        if (searchFlowOfferDataStorage.isHealthy()) {
            return Health.up().build();
        } else {
            return Health.down().build();
        }
    }
}
