package ru.yandex.travel.hotels.searcher.logging;

import com.google.gson.JsonObject;
import io.netty.handler.codec.http.HttpHeaders;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.springframework.core.env.Environment;

import ru.yandex.travel.commons.logging.LoggingMarkers;

public class HttpRequestLogger {
    private Logger logger;
    private Environment environment;
    private boolean isMocked;
    private String partnerName;
    private String requestIdHeader;

    public HttpRequestLogger(String requestIdHeader, Logger logger, Environment environment, boolean isMocked, String partnerName) {
        this.logger = logger;
        this.environment = environment;
        this.isMocked = isMocked;
        this.partnerName = partnerName;
        this.requestIdHeader = requestIdHeader;
    }

    public void logRequestResponse(Request request, Response response, String purpose, Throwable error) {
        if (logger != null) {
            JsonObject message = getJsonLogMessage();
            String httpRequestId = request.getHeaders().get(requestIdHeader);
            message.addProperty("HttpRequestID", httpRequestId);
            message.addProperty("HttpMethod", request.getMethod());
            message.addProperty("HttpRequestUrl", request.getUrl());
            message.addProperty("HttpRequestHeaders", serializeHeaders(request.getHeaders()).toString());
            message.addProperty("HttpRequestBody", request.getStringData());
            message.addProperty("HttpResponseHeaders", response != null ? serializeHeaders(response.getHeaders()).toString() : null);
            message.addProperty("RequestPurpose", purpose);
            message.addProperty("HttpResponseCode", response != null ? response.getStatusCode() : null);
            message.addProperty("HttpResponseBody", response != null ? response.getResponseBody() : null);
            message.addProperty("ErrorType", error != null ? error.getClass().getSimpleName() : null);
            message.addProperty("ErrorMessage", error != null ? error.getMessage() : null);
            message.addProperty("Partner", partnerName);
            logger.info(LoggingMarkers.HTTP_REQUEST_RESPONSE_MARKER, message.toString());
        }
    }

    private JsonObject serializeHeaders(HttpHeaders headers) {
        JsonObject res = new JsonObject();
        headers.iteratorAsString().forEachRemaining(e -> res.addProperty(e.getKey(), e.getValue()));
        return res;
    }

    private JsonObject getJsonLogMessage() {
        JsonObject message = new JsonObject();
        message.addProperty("Timestamp", System.currentTimeMillis());
        if (environment != null && environment.getActiveProfiles().length > 0) {
            message.addProperty("Environment", environment.getActiveProfiles()[0]);
        } else {
            message.addProperty("Environment", "dev");
        }
        message.addProperty("IsMocked", isMocked);
        return message;
    }
}
