package ru.yandex.travel.hotels.searcher.partners;

import javax.validation.constraints.NotNull;
import java.time.Duration;

import lombok.Data;

@Data
public abstract class AbstractPartnerTaskHandlerProperties {
    @NotNull
    private String baseUrl;
    private Duration httpReadTimeout = Duration.ofSeconds(15);
    private Duration httpRequestTimeout = Duration.ofSeconds(30);
    // Bucket duration defines the time span to limit requests per time span.
    private Duration rateLimiterBucket = Duration.ofSeconds(1);
    private Duration rateLimiterWindow = Duration.ofSeconds(5);
    private Duration rescheduleTimeout = Duration.ofSeconds(1);
    private Duration concurrencyReschedulePeriod = Duration.ofMillis(100);
    private Duration consumerSleepTime = Duration.ofMillis(100);
    // No more than X requests within the bucket duration.
    private int interactiveRateLimit = 20;
    // No more than X requests in parallel.
    private int interactiveConcurrencyLimit = 20;
    private int interactiveThreadPoolSize = 2;
    private int backgroundRateLimit = 5;
    private int backgroundConcurrencyLimit = 3;
    private int backgroundThreadPoolSize = 1;
    private int calendarRateLimit = 10;
    private int calendarConcurrencyLimit = 1;
    private int calendarThreadPollSize = 1;
    // No more than X requests in the queue.
    private int backgroundQueueLimit = 100;
    private int calendarQueueLimit = 100;
    private int maxBatchSize = 1;
    private boolean enabled = true;
    // Offers and related lifetimes - how long bus messages live in bus
    private Duration maxNonEmptyLifetime;
    private Duration placeholderLifetime = Duration.ofMinutes(3);
    private Duration errorLifetime = Duration.ofMinutes(3);
    private Duration speculativeRetryTimeout = Duration.ofMillis(1000);
    private int speculativeRetriesCount = 0;
    private double speculativeRetryRateLimit = 0.2;
    private Duration searchFlowOfferDataLifetime = Duration.ofDays(7);
}
