package ru.yandex.travel.hotels.searcher.partners;

import java.time.Duration;
import java.util.Map;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Getter
@Setter
@Validated
@ConfigurationProperties(value = "partners.bnovo", ignoreUnknownFields = false)
public class BNovoTaskHandlerProperties extends AbstractPartnerTaskHandlerProperties {
    @NotBlank
    private String username;
    @NotBlank
    private String password;
    @NotNull
    private Duration tokenValidityDuration;
    @NotBlank
    private String privateApiBaseUrl;
    @NotBlank
    private String pricesLosApiBaseUrl;
    private boolean cacheContent;
    private int contentCacheSize;
    private Duration contentCacheDuration;
    private boolean remapIds;
    private boolean enableRetries;
    private boolean allowBeds;
    private int authenticationMaxRetryCount;
}
