package ru.yandex.travel.hotels.searcher.partners;

import java.time.Duration;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotEmpty;

@EqualsAndHashCode(callSuper = true)
@ConfigurationProperties(value = "partners.booking", ignoreUnknownFields = false)
@Validated
@Data
public class BookingPartnerTaskHandlerProperties extends AbstractPartnerTaskHandlerProperties {
    @NotEmpty
    private String affiliateId;
    @NotEmpty
    private String username;
    @NotEmpty
    private String password;

    private boolean failOnNotFoundHotelId;

    private boolean cacheContent;
    private int contentCacheSize;
    private Duration contentCacheDuration;
}
