package ru.yandex.travel.hotels.searcher.partners;

import java.time.Duration;

import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.common.partners.bronevik.BronevikClientProperties;

@EqualsAndHashCode(callSuper = true)
@ConfigurationProperties(value = "partners.bronevik", ignoreUnknownFields = false)
@Validated
@Data
public class BronevikTaskHandlerProperties extends AbstractPartnerTaskHandlerProperties{

    public BronevikClientProperties client;

    private boolean cacheContent;
    private int contentCacheSize;
    private Duration contentCacheDuration;
    private Integer checkinCheckoutRange = 60;
    private boolean enableHotelTimezone;
}
