package ru.yandex.travel.hotels.searcher.partners;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.HashMap;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "partners.dolphin", ignoreUnknownFields = false)
@Validated
@Getter
@Setter
public class DolphinTaskHandlerProperties extends AbstractPartnerTaskHandlerProperties {
    @NotNull
    private String login;
    @NotNull
    private String password;
    @NotNull
    private Duration auxUpdateInterval;
    @NotNull
    private Duration auxRetryInterval;
    @NotEmpty
    private String defaultTimeZone;
    @NotNull
    private Integer hotelCacheSize;
    @NotNull
    private Duration hotelCacheTtl;
    @NotNull
    @NotEmpty
    private HashMap<Integer, BigDecimal> cancellationPenalties;
}
