package ru.yandex.travel.hotels.searcher.partners;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.time.Duration;

import ru.yandex.misc.ip.IpAddress;
import ru.yandex.travel.hotels.common.partners.expedia.ApiVersion;
import ru.yandex.travel.hotels.common.partners.expedia.ProfileType;

@ConfigurationProperties(value = "partners.expedia", ignoreUnknownFields = false)
@Validated
@Getter @Setter
public class ExpediaTaskHandlerProperties extends AbstractPartnerTaskHandlerProperties {
    @NotEmpty
    private String apiKey;

    @NotEmpty
    private String secret;

    @NotNull
    private ApiVersion defaultApiVersion;

    private boolean includeFencedRates;

    @NotNull
    private Duration tokenValidityPeriod;

    @NotEmpty
    private String searchIpAddress;

    @NotNull
    private ProfileType profileType;

    @NotEmpty
    private String requestCurrency;

    @NotNull
    private Duration safetyInterval;

    private boolean searchFencedDeals;
    private boolean searchMobileDeals;
    private boolean dropRestrictedOffers;

    private boolean enablePropertyPansions;

    @NotNull
    private Integer propertyContentCacheSize;

    @NotNull
    private Duration propertyContentCacheTtl;
}
