package ru.yandex.travel.hotels.searcher.partners;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotEmpty;

@ConfigurationProperties(value = "partners.hotelscombined", ignoreUnknownFields = false)
@Validated
public class HotelsCombinedTaskHandlerProperties extends AbstractPartnerTaskHandlerProperties {
    @NotEmpty
    private String apiKey;

    private String baseMhsUrl;

    public String getApiKey() {
        return apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getBaseMhsUrl() {
        return baseMhsUrl;
    }

    public void setBaseMhsUrl(String baseMhsUrl) {
        this.baseMhsUrl = baseMhsUrl;
    }
}
