package ru.yandex.travel.hotels.searcher.partners;

import java.time.LocalDate;
import java.util.concurrent.CompletableFuture;

import org.javamoney.moneta.Money;

import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.travel.hotels.common.partners.travelline.TravellineClient;
import ru.yandex.travel.hotels.common.partners.travelline.model.CancelReservationResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.ConfirmReservationResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelChainDetailsResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelDetailsResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelInfo;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelInventoryResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelOfferAvailability;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelReservationRequest;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelReservationResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.HotelStatusChangedResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.ListHotelsResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.MakeExtraPaymentResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.ReadReservationResponse;
import ru.yandex.travel.hotels.common.partners.travelline.model.VerifyReservationRequest;
import ru.yandex.travel.hotels.common.partners.travelline.model.VerifyReservationResponse;
import ru.yandex.travel.hotels.searcher.ThrottledWrapper;

public class ThrottledTravellineClient extends ThrottledWrapper<TravellineClient> implements TravellineClient {
    public ThrottledTravellineClient(TravellineClient wrapped, ThrottlingParameters parameters, String name,
                                     String... tags) {
        super(wrapped, parameters, name, tags);
    }

    @Override
    public CompletableFuture<HotelInfo> getHotelInfo(String hotelCode) {
        return wrapped.getHotelInfo(hotelCode);
    }

    @Override
    public CompletableFuture<HotelOfferAvailability> findOfferAvailability(String hotelCode, LocalDate checkinDate,
                                                                           LocalDate checkoutDate) {
        return call(() -> wrapped.findOfferAvailability(hotelCode, checkinDate, checkoutDate));
    }

    @Override
    public CompletableFuture<HotelInfo> getHotelInfo(String hotelCode, String requestId) {
        throw new NotImplementedException();
    }

    @Override
    public CompletableFuture<HotelOfferAvailability> findOfferAvailability(String hotelCode, LocalDate checkinDate,
                                                                           LocalDate checkoutDate, String requestId) {
        return call(() -> wrapped.findOfferAvailability(hotelCode, checkinDate, checkoutDate, requestId));
    }

    @Override
    public CompletableFuture<VerifyReservationResponse> verifyReservation(VerifyReservationRequest request) {
        throw new NotImplementedException();
    }

    @Override
    public CompletableFuture<HotelReservationResponse> createReservation(HotelReservationRequest request) {
        throw new NotImplementedException();
    }

    @Override
    public CompletableFuture<ConfirmReservationResponse> confirmReservation(String yandexNumber,
                                                                            String transactionNumber, Money amount) {
        throw new NotImplementedException();
    }

    @Override
    public CompletableFuture<MakeExtraPaymentResponse> makeExtraPayment(String yandexNumber, String transactionNumber,
                                                                        Money amount) {
        throw new NotImplementedException();
    }

    @Override
    public CompletableFuture<CancelReservationResponse> cancelReservation(String yandexNumber) {
        throw new NotImplementedException();
    }

    @Override
    public CompletableFuture<ReadReservationResponse> readReservation(String yandexNumber) {
        throw new NotImplementedException();
    }

    @Override
    public CompletableFuture<HotelInventoryResponse> getHotelInventory(String hotelCode) {
        return call(() -> wrapped.getHotelInventory(hotelCode));
    }

    @Override
    public CompletableFuture<ListHotelsResponse> listHotels() {
        return wrapped.listHotels();
    }

    @Override
    public CompletableFuture<HotelStatusChangedResponse> notifyHotelStatusChanged(String hotelCode) {
        throw new NotImplementedException();
    }

    @Override
    public CompletableFuture<HotelDetailsResponse> getHotelDetails(String hotelCode) {
        throw new NotImplementedException();
    }

    @Override
    public CompletableFuture<HotelChainDetailsResponse> getHotelChainDetails(String inn) {
        throw new NotImplementedException();
    }
}
