package ru.yandex.travel.hotels.searcher.partners;

import java.time.Duration;
import java.util.Set;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.searcher.services.cache.travelline.availability.CachedTravellineAvailabilitySearcherProperties;
import ru.yandex.travel.hotels.searcher.services.cache.travelline.hotels.CachedTravellineHotelInfoSearcherProperties;

@ConfigurationProperties(value = "partners.travelline", ignoreUnknownFields = false)
@Validated
@Getter
@Setter
public class TravellineTaskHandlerProperties extends AbstractPartnerTaskHandlerProperties {
    @NotEmpty
    private String apiKey;

    @Valid
    @NotNull
    private CacheProperties cache;

    private Set<String> apartmentExceptions;
    @NotNull
    private Boolean alwaysAllowChildrenAsAdults;
    @NotNull
    private ThrottlersProperties throttlers;

    @Validated
    @Getter
    @Setter
    public static class CacheProperties {
        private CachedTravellineAvailabilitySearcherProperties availability;
        private CachedTravellineHotelInfoSearcherProperties hotels;
        private boolean inMemory;
    }

    @Getter
    @Setter
    @Validated
    public static class ThrottlersProperties {
        @NotNull
        private TravellineTaskHandlerProperties.ThrottlerProperties interactive;
        @NotNull
        private TravellineTaskHandlerProperties.ThrottlerProperties background;
        @NotNull
        private TravellineTaskHandlerProperties.ThrottlerProperties inventory;
    }

    @Validated
    @Getter
    @Setter
    public static class ThrottlerProperties {
        @NotNull
        private Integer rateLimit;
        @NotNull
        private Integer concurrencyLimit;
        @NotNull
        private Duration bucket;
        @NotNull
        private Duration window;
        private Integer queueLimit;
    }

}
