package ru.yandex.travel.hotels.searcher.services;

import java.time.Duration;
import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.orders.client.FailureDetectorProperties;
import ru.yandex.travel.orders.client.yp.YpDiscoveryProperties;

@ConfigurationProperties("exchange")
@Validated
@Getter
@Setter
public class ExchangeRateConfigurationProperties {
    private List<String> targets;
    @Valid
    private YpDiscoveryProperties yp;
    private boolean enabled;

    @NotNull
    private Duration timeout;

    @NotNull
    private Duration refreshInterval;
    
    @Valid
    private FailureDetectorProperties failureDetection;

    private Tvm tvm;

    @Getter
    @Setter
    @Validated
    public static class Tvm {
        private boolean enabled;
        private String destinationAlias;
    }


}

