package ru.yandex.travel.hotels.searcher.services;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;

import ru.yandex.travel.commons.proto.ECurrency;
import ru.yandex.travel.hotels.searcher.services.entities.ExchangeRate;

public class StubbedExchangeRateService implements ExchangeRateService {
    private static float DEFAULT_FX_RATE = 66.0f;

    @Override
    public Optional<ExchangeRate> getExchangeRate(ECurrency fromCurrency, ECurrency toCurrency) {
        if (fromCurrency == toCurrency) {
            return Optional.of(ExchangeRate.builder()
                    .rateValue(1.00f)
                    .rateValidUntil(Instant.MAX)
                    .build());
        }
        return Optional.of(ExchangeRate.builder()
                .rateValue(DEFAULT_FX_RATE)
                .rateValidUntil(Instant.now().plus(24L, ChronoUnit.HOURS))
                .build());
    }
}
