package ru.yandex.travel.hotels.searcher.services.cache;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public interface Actualizable<T> {
    T getCached();

    default CompletableFuture<Actualizable<T>> actualize() {
        return this.actualize(null);
    }

    CompletableFuture<Actualizable<T>> actualize(String httpRequestId);

    default <V> CompletableFuture<V> getAndFetchActual(Function<T, V> fetcher) {
        return this.getAndFetchActual(fetcher, null);
    }

    default <V> CompletableFuture<V> getAndFetchActual(Function<T, V> fetcher, String httpRequestId) {
        T cached = getCached();
        V value = fetcher.apply(cached);
        if (value == null) {
            return actualize(httpRequestId).thenApply(a -> fetcher.apply(a.getCached()));
        } else {
            return CompletableFuture.completedFuture(value);
        }
    }
}
