package ru.yandex.travel.hotels.searcher.services.cache;

import java.util.concurrent.CompletableFuture;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.function.Function;

@RequiredArgsConstructor(access = AccessLevel.PRIVATE)
public class CachedActualizable<T> implements Actualizable<T> {

    @Getter
    private final T cached;

    @Override
    public CompletableFuture<Actualizable<T>> actualize(String httpRequestId) {
        return CompletableFuture.completedFuture(this);
    }

    public static <T> Actualizable<T> oneValue(T t) {
        return new CachedActualizable<>(t);
    }

    public static <T> Function<T, Actualizable<T>> wrap(Function<String, CompletableFuture<Actualizable<T>>> fn) {
        return cached -> new CachedActualizable<T>(cached) {
            @Override
            public CompletableFuture<Actualizable<T>> actualize(String httpRequestId) {
                return fn.apply(httpRequestId);
            }
        };
    }
}
