package ru.yandex.travel.hotels.searcher.services.cache.bnovo;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.common.partners.bnovo.BNovoClient;
import ru.yandex.travel.hotels.searcher.partners.BNovoTaskHandlerProperties;

@Configuration
@EnableConfigurationProperties({BNovoTaskHandlerProperties.class, BNovoYtCacheProperties.class})
@RequiredArgsConstructor
public class BNovoCacheConfiguration {
    private final BNovoTaskHandlerProperties properties;
    private final BNovoClient client;

    @Bean
    @ConditionalOnProperty("partners.bnovo.cache-content")
    public RatePlanSearcher cachedRatePlanSearcher() {
        return new CachedRatePlanSearcher(client, properties.getContentCacheSize(),
                properties.getContentCacheDuration());
    }

    @Bean
    @ConditionalOnProperty("partners.bnovo.cache-content")
    public RoomTypeSearcher cachedRoomTypeSearcher() {
        return new CachedRoomTypeSearcher(client, properties.getContentCacheSize(),
                properties.getContentCacheDuration());
    }

    @Bean
    @ConditionalOnProperty("partners.bnovo.cache-content")
    public HotelInfoSearcher cachedHotelInfoSearcher() {
        return new CachedHotelInfoSearcher(client, properties.getContentCacheSize(),
                properties.getContentCacheDuration());
    }

    @Bean
    @ConditionalOnProperty("partners.bnovo.cache-content")
    public ServicesSearcher cachedServicesSearcher() {
        return new CachedServicesSearcher(client, properties.getContentCacheSize(),
                properties.getContentCacheDuration());
    }

    @Bean
    @ConditionalOnMissingBean(RatePlanSearcher.class)
    public RatePlanSearcher directRatePlanSearcher() {
        return new DirectRatePlanSearcher(client);
    }

    @Bean
    @ConditionalOnMissingBean(RoomTypeSearcher.class)
    public RoomTypeSearcher directRoomTypeSearcher() {
        return new DirectRoomTypeSearcher(client);
    }

    @Bean
    @ConditionalOnMissingBean(HotelInfoSearcher.class)
    public HotelInfoSearcher directHotelInfoSearcher() {
        return new DirectHotelInfoSearcher(client);
    }

    @Bean
    @ConditionalOnMissingBean(ServicesSearcher.class)
    public ServicesSearcher directServicesSearcher() {
        return new DirectServicesSearcher(client);
    }
}
