package ru.yandex.travel.hotels.searcher.services.cache.bnovo;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.bnovo.BNovoClient;
import ru.yandex.travel.hotels.common.partners.bnovo.model.Hotel;
import ru.yandex.travel.hotels.searcher.services.cache.SimpleAsyncCache;

@Slf4j
public class CachedHotelInfoSearcher extends SimpleAsyncCache<Long, Hotel> implements HotelInfoSearcher {
    private final HotelInfoSearcher directSearcher;

    public CachedHotelInfoSearcher(BNovoClient client, int cacheSize, Duration cacheDuration) {
        super(cacheSize, cacheDuration, (accoundId)->{
            return client.getHotelByAccountIdSync(accoundId, null);
        }, "searcher.partners.bnovo", "hotelCache");
        directSearcher = new DirectHotelInfoSearcher(client);
    }

    @Override
    public CompletableFuture<Hotel> getHotel(long accountId, CallContext callContext, String httpRequestId) {
        if (callContext.getTestContext() != null) {
            log.info("Test context found, will skip caching");
            return directSearcher.getHotel(accountId, callContext, httpRequestId);
        } else {
            return get(accountId);
        }
    }
}
