package ru.yandex.travel.hotels.searcher.services.cache.bnovo;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.bnovo.BNovoClient;
import ru.yandex.travel.hotels.common.partners.bnovo.model.RatePlan;
import ru.yandex.travel.hotels.searcher.services.cache.Actualizable;
import ru.yandex.travel.hotels.searcher.services.cache.ActualizableCache;

@Slf4j
public class CachedRatePlanSearcher extends ActualizableCache<Long, Map<Long, RatePlan>> implements RatePlanSearcher {
    private final RatePlanSearcher directSearcher;

    public CachedRatePlanSearcher(BNovoClient client, int cacheSize, Duration cacheDuration) {
        super(cacheSize, cacheDuration, client::getRatePlansSync, "searcher.partners.bnovo", "ratePlanCache");
        this.directSearcher = new DirectRatePlanSearcher(client);
    }

    @Override
    public CompletableFuture<Actualizable<Map<Long, RatePlan>>> getRatePlansForHotel(long hotelId,
                                                                                     CallContext callContext,
                                                                                     String httpRequestId) {
        if (callContext.getTestContext() != null) {
            log.info("Test context found, will skip caching");
            return directSearcher.getRatePlansForHotel(hotelId, callContext, httpRequestId);
        }
        return this.get(hotelId);
    }
}
