package ru.yandex.travel.hotels.searcher.services.cache.bnovo;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.bnovo.BNovoClient;
import ru.yandex.travel.hotels.common.partners.bnovo.model.RoomType;
import ru.yandex.travel.hotels.searcher.services.cache.Actualizable;
import ru.yandex.travel.hotels.searcher.services.cache.ActualizableCache;

@Slf4j
public class CachedRoomTypeSearcher extends ActualizableCache<Long, Map<Long, RoomType>> implements RoomTypeSearcher {
    private final RoomTypeSearcher directSearcher;

    public CachedRoomTypeSearcher(BNovoClient client, int cacheSize, Duration cacheDuration) {
        super(cacheSize, cacheDuration,
                client::getRoomTypesSync,
                "searcher.partners.bnovo", "roomTypeCache");
        directSearcher = new DirectRoomTypeSearcher(client);
    }

    @Override
    public CompletableFuture<Actualizable<Map<Long, RoomType>>> getRoomTypesForHotel(long hotelId,
                                                                                     CallContext callContext,
                                                                                     String httpRequestId) {
        if (callContext.getTestContext() != null) {
            log.info("Test context found, will skip caching");
            return directSearcher.getRoomTypesForHotel(hotelId, callContext, httpRequestId);
        }
        return this.get(hotelId);
    }
}
