package ru.yandex.travel.hotels.searcher.services.cache.bnovo;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.bnovo.BNovoClient;
import ru.yandex.travel.hotels.common.partners.bnovo.model.Service;
import ru.yandex.travel.hotels.searcher.services.cache.SimpleAsyncCache;

@Slf4j
public class CachedServicesSearcher extends SimpleAsyncCache<Long, Map<Long, Service>> implements ServicesSearcher {
    private final ServicesSearcher directSearcher;


    public CachedServicesSearcher(BNovoClient client, int cacheSize, Duration cacheDuration) {
        super(cacheSize, cacheDuration,
                accountId -> client.getServicesSync(accountId, null),
                "searcher.partners.bnovo", "serviceCache");
        this.directSearcher = new DirectServicesSearcher(client);
    }

    @Override
    public CompletableFuture<Map<Long, Service>> getServicesForHotel(long accountId, CallContext callContext,
                                                                     String httpRequestId) {
        if (callContext.getTestContext() != null) {
            log.info("Test context found, will skip caching");
            return directSearcher.getServicesForHotel(accountId, callContext, httpRequestId);
        }
        return this.get(accountId);
    }
}
