package ru.yandex.travel.hotels.searcher.services.cache.bnovo;

import java.util.concurrent.CompletableFuture;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.bnovo.BNovoClient;
import ru.yandex.travel.hotels.common.partners.bnovo.model.Hotel;

@RequiredArgsConstructor
public class DirectHotelInfoSearcher implements HotelInfoSearcher {
    private final BNovoClient client;

    @Override
    public CompletableFuture<Hotel> getHotel(long accountId, CallContext callContext, String httpRequestId) {
        return client.withCallContext(callContext).getHotelByAccountId(accountId, httpRequestId);
    }
}
