package ru.yandex.travel.hotels.searcher.services.cache.bnovo;

import java.util.Map;
import java.util.concurrent.CompletableFuture;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.bnovo.BNovoClient;
import ru.yandex.travel.hotels.common.partners.bnovo.model.RatePlan;
import ru.yandex.travel.hotels.searcher.services.cache.Actualizable;
import ru.yandex.travel.hotels.searcher.services.cache.CachedActualizable;

@RequiredArgsConstructor
public class DirectRatePlanSearcher implements RatePlanSearcher {
    private final BNovoClient client;

    @Override
    public CompletableFuture<Actualizable<Map<Long, RatePlan>>> getRatePlansForHotel(long hotelId,
                                                                                     CallContext callContext,
                                                                                     String httpRequestId) {
        return client.withCallContext(callContext)
                .getRatePlans(hotelId, httpRequestId)
                .thenApply(CachedActualizable::oneValue);
    }
}
