package ru.yandex.travel.hotels.searcher.services.cache.bnovo;

import java.util.Map;
import java.util.concurrent.CompletableFuture;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.bnovo.BNovoClient;
import ru.yandex.travel.hotels.common.partners.bnovo.model.RoomType;
import ru.yandex.travel.hotels.searcher.services.cache.Actualizable;
import ru.yandex.travel.hotels.searcher.services.cache.CachedActualizable;

@RequiredArgsConstructor
public class DirectRoomTypeSearcher implements RoomTypeSearcher {
    private final BNovoClient client;


    @Override
    public CompletableFuture<Actualizable<Map<Long, RoomType>>> getRoomTypesForHotel(long hotelId,
                                                                                     CallContext callContext,
                                                                                     String httpRequestId) {
        return client.withCallContext(callContext)
                .getRoomTypes(hotelId, httpRequestId)
                .thenApply(CachedActualizable::oneValue);
    }
}
