package ru.yandex.travel.hotels.searcher.services.cache.bnovo;

import java.util.Map;
import java.util.concurrent.CompletableFuture;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.bnovo.BNovoClient;
import ru.yandex.travel.hotels.common.partners.bnovo.model.Service;

@RequiredArgsConstructor
public class DirectServicesSearcher implements ServicesSearcher {
    private final BNovoClient client;

    @Override
    public CompletableFuture<Map<Long, Service>> getServicesForHotel(long hotelId,
                                                                     CallContext callContext,
                                                                     String httpRequestId) {
        return client.withCallContext(callContext).getServices(hotelId, httpRequestId);
    }
}
