package ru.yandex.travel.hotels.searcher.services.cache.booking;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.common.partners.booking.BookingClient;
import ru.yandex.travel.hotels.searcher.partners.BookingPartnerTaskHandlerProperties;
import ru.yandex.travel.hotels.searcher.services.cache.booking.hotels.BookingHotelSearcher;
import ru.yandex.travel.hotels.searcher.services.cache.booking.hotels.CachedBookingHotelSearcher;
import ru.yandex.travel.hotels.searcher.services.cache.booking.hotels.DirectBookingHotelSearcher;

@Configuration
@EnableConfigurationProperties({BookingPartnerTaskHandlerProperties.class})
@RequiredArgsConstructor
public class BookingCacheConfiguration {
    private final BookingPartnerTaskHandlerProperties properties;
    private final BookingClient client;

    @Bean
    @ConditionalOnProperty("partners.booking.cache-content")
    public BookingHotelSearcher cachedHotelSearcher() {
        return new CachedBookingHotelSearcher(client, properties.getContentCacheSize(),
                properties.getContentCacheDuration());
    }

    @Bean
    @ConditionalOnMissingBean(BookingHotelSearcher.class)
    public BookingHotelSearcher directHotelSearcher() {
        return new DirectBookingHotelSearcher(client);
    }
}
