package ru.yandex.travel.hotels.searcher.services.cache.booking.hotels;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.common.partners.booking.BookingClient;
import ru.yandex.travel.hotels.common.partners.booking.model.Hotel;
import ru.yandex.travel.hotels.searcher.services.cache.SimpleAsyncCache;

@Validated
public class CachedBookingHotelSearcher extends SimpleAsyncCache<String, Hotel> implements BookingHotelSearcher {
    private final BookingClient client;

    public CachedBookingHotelSearcher(BookingClient client, int cacheSize, Duration cacheDuration) {
        super(cacheSize, cacheDuration,
              (hotelId) -> client.getHotelSync(hotelId, null),
              "searcher.partners.booking", "hotelCache");

        this.client = client;
    }

    @Override
    public CompletableFuture<Map<String, Hotel>> getHotels(Set<String> hotelIds) {
        return getAll(hotelIds, (missingHotelIds, executor) -> {
            Set<String> ids = StreamSupport.stream(missingHotelIds.spliterator(), false)
                    .collect(Collectors.toSet());

            return client.getHotels(ids, null).thenApply(hotels -> {
                Map<String, Hotel> result = new HashMap<>();

                hotels.getResult().forEach(hotel -> result.put(hotel.getHotelId().toString(), hotel));

                return result;
            });
        });
    }
}
