package ru.yandex.travel.hotels.searcher.services.cache.booking.hotels;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

import ru.yandex.travel.hotels.common.partners.booking.BookingClient;
import ru.yandex.travel.hotels.common.partners.booking.model.Hotel;

public class DirectBookingHotelSearcher implements BookingHotelSearcher {

    private BookingClient client;

    public DirectBookingHotelSearcher(BookingClient client) {
        this.client = client;
    }

    @Override
    public CompletableFuture<Map<String, Hotel>> getHotels(Set<String> hotelIds) {
        return client.getHotels(hotelIds, null)
                .thenApply(hotels -> {
                    Map<String, Hotel> result = new HashMap<>();

                    hotels.getResult().forEach(hotel -> result.put(hotel.getHotelId().toString(), hotel));

                    return result;
                });
    }
}
