package ru.yandex.travel.hotels.searcher.services.cache.bronevik;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.common.partners.bronevik.BronevikClient;
import ru.yandex.travel.hotels.searcher.partners.BronevikTaskHandlerProperties;
import ru.yandex.travel.hotels.searcher.services.cache.bronevik.hotelInfo.BronevikHotelInfoSearcher;
import ru.yandex.travel.hotels.searcher.services.cache.bronevik.hotelInfo.CachedBronevikHotelInfoSearcher;
import ru.yandex.travel.hotels.searcher.services.cache.bronevik.hotelInfo.DirectBronevikHotelInfoSearcher;

@Configuration
@EnableConfigurationProperties({BronevikTaskHandlerProperties.class})
@RequiredArgsConstructor
public class BronevikCacheConfiguration {

    private final BronevikTaskHandlerProperties properties;
    private final BronevikClient client;

    @Bean
    @ConditionalOnProperty("partners.bronevik.cache-content")
    public BronevikHotelInfoSearcher cachedBronevikHotelInfoSearcher() {
        return new CachedBronevikHotelInfoSearcher(client, properties.getContentCacheSize(),
                properties.getContentCacheDuration());
    }

    @Bean
    @ConditionalOnMissingBean(BronevikHotelInfoSearcher.class)
    public BronevikHotelInfoSearcher directBronevikHotelInfoSearcher() {
        return new DirectBronevikHotelInfoSearcher(client);
    }
}
