package ru.yandex.travel.hotels.searcher.services.cache.bronevik.hotelInfo;

import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.common.partners.bronevik.BronevikClient;
import ru.yandex.travel.hotels.common.partners.bronevik.HotelWithInfo;
import ru.yandex.travel.hotels.searcher.services.cache.SimpleAsyncCache;

@Validated
public class CachedBronevikHotelInfoSearcher extends SimpleAsyncCache<Integer, HotelWithInfo> implements BronevikHotelInfoSearcher {
    BronevikClient bronevikClient;

    public CachedBronevikHotelInfoSearcher(BronevikClient bronevikClient, int cacheSize, Duration cacheDuration) {
        super(
                cacheSize,
                cacheDuration,
                (hotelId) -> bronevikClient.getHotelInfoSync(hotelId, null),
                "searcher.partners.bronevik",
                "hotelInfoCache");
        this.bronevikClient = bronevikClient;
    }

    @Override
    public CompletableFuture<Map<Integer, HotelWithInfo>> getHotelsInfo(List<Integer> hotelIds) {

        return getAll(new HashSet<>(hotelIds), (missingHotelIds, executor) -> {
            List<Integer> ids = StreamSupport.stream(missingHotelIds.spliterator(), false)
                    .collect(Collectors.toList());
            return bronevikClient.getHotelsInfo(ids, null).thenApply(response -> {
                Map<Integer, HotelWithInfo> result = new HashMap<>();

                response.getHotel().forEach(hotel -> result.put(hotel.getId(), hotel));
                return result;
            });
        });

    }
}
