package ru.yandex.travel.hotels.searcher.services.cache.bronevik.hotelInfo;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;

import ru.yandex.travel.hotels.common.partners.bronevik.BronevikClient;
import ru.yandex.travel.hotels.common.partners.bronevik.HotelWithInfo;

public class DirectBronevikHotelInfoSearcher implements BronevikHotelInfoSearcher {

    BronevikClient bronevikClient;

    public DirectBronevikHotelInfoSearcher(BronevikClient bronevikClient) {
        this.bronevikClient = bronevikClient;
    }

    @Override
    public CompletableFuture<Map<Integer, HotelWithInfo>> getHotelsInfo(List<Integer> hotelIds) {
        return bronevikClient.getHotelsInfo(hotelIds, null)
                .thenApply(response -> response.getHotel().stream().collect(Collectors.toMap(HotelWithInfo::getId, Function.identity())));
    }
}
