package ru.yandex.travel.hotels.searcher.services.cache.dolphin;

import lombok.Data;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.common.partners.dolphin.proto.THotelCoordinates;
import ru.yandex.travel.hotels.common.partners.dolphin.utils.RoomNameNormalizer;
import ru.yandex.travel.hotels.common.partners.dolphin.utils.RoomNameNormalizerRules;
import ru.yandex.travel.hotels.common.partners.dolphin.utils.coordinates.DolphinHotelCoordinatesProvider;
import ru.yandex.travel.hotels.common.partners.dolphin.utils.coordinates.DummyDolphinHotelCoordinatesProvider;
import ru.yandex.travel.hotels.common.partners.dolphin.utils.coordinates.YtDolphinHotelCoordinatesService;
import ru.yandex.travel.yt_lucene_index.ProtobufYtLuceneIndexBuilder;

@Configuration
@EnableConfigurationProperties({DolphinYtCacheProperties.class})
@RequiredArgsConstructor
@Data
public class DolphinYtCacheConfiguration {

    private final DolphinYtCacheProperties ytCacheProperties;

    @Bean
    public RoomNameNormalizerRules getRoomNameNormalizeRules() {
        return RoomNameNormalizerRules.fromBaseProperties(ytCacheProperties);
    }

    @Bean
    public RoomNameNormalizer getRoomNameNormalizer(RoomNameNormalizerRules normalizeRules) {
        return new RoomNameNormalizer(normalizeRules);
    }

    @Bean
    public DolphinHotelCoordinatesProvider dolphinHotelCoordinatesProvider()  {
        if (ytCacheProperties.getHotelCoordinatesParams().isEnabled()) {
            var luceneIndexBuilder = new ProtobufYtLuceneIndexBuilder<THotelCoordinates>()
                    .setProtoClass(THotelCoordinates.class);
            return new YtDolphinHotelCoordinatesService(ytCacheProperties.getHotelCoordinatesParams(), luceneIndexBuilder);
        }

        return new DummyDolphinHotelCoordinatesProvider();
    }
}
