package ru.yandex.travel.hotels.searcher.services.cache.dolphin;

import javax.validation.Valid;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.common.partners.dolphin.BaseDolphinYtCacheProperties;
import ru.yandex.travel.yt_lucene_index.SwitchableYtLuceneIndexParams;

@EqualsAndHashCode(callSuper = true)
@ConfigurationProperties(value = "yt.cache.dolphin", ignoreUnknownFields = false)
@Data
@Validated
public class DolphinYtCacheProperties extends BaseDolphinYtCacheProperties {
    @Valid
    private SwitchableYtLuceneIndexParams hotelCoordinatesParams;
}
