package ru.yandex.travel.hotels.searcher.services.cache.expedia;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.common.partners.expedia.proto.THotelCoordinates;
import ru.yandex.travel.hotels.common.partners.expedia.utils.coordinates.DummyExpediaHotelCoordinatesProvider;
import ru.yandex.travel.hotels.common.partners.expedia.utils.coordinates.ExpediaHotelCoordinatesProvider;
import ru.yandex.travel.hotels.common.partners.expedia.utils.coordinates.YtExpediaHotelCoordinatesService;
import ru.yandex.travel.yt_lucene_index.ProtobufYtLuceneIndexBuilder;

@Configuration
@EnableConfigurationProperties(ExpediaYtCacheProperties.class)
@RequiredArgsConstructor
public class ExpediaYtCacheConfiguration {
    private final ExpediaYtCacheProperties properties;

    @Bean
    @ConditionalOnProperty("partners.expedia.enable-property-pansions")
    public ExpediaPropertyPansions expediaPropertyPansions() {
        return new YtExpediaPropertyPansions(properties.getPropertyPansionsParams());
    }

    @Bean
    @ConditionalOnMissingBean(ExpediaPropertyPansions.class)
    public ExpediaPropertyPansions emptyExpediaPropertyPansions() {
        return new EmptyExpediaPropertyPansions();
    }

    @Bean
    public ExpediaHotelCoordinatesProvider expediaHotelCoordinatesProvider() {
        if (properties.getHotelCoordinatesParams().isEnabled()) {
            ProtobufYtLuceneIndexBuilder<THotelCoordinates> luceneIndexBuilder = new ProtobufYtLuceneIndexBuilder<THotelCoordinates>()
                    .setProtoClass(THotelCoordinates.class);

            return new YtExpediaHotelCoordinatesService(properties.getHotelCoordinatesParams(), luceneIndexBuilder);
        } else {
            return new DummyExpediaHotelCoordinatesProvider();
        }
    }
}
